/******************************************************************************/
class RemoveLight : BaseEvent
{
public:
            RemoveLight();
   virtual ~RemoveLight();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      ); 
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   VarPointLight* m_VarPointLight;
   UID m_VarPointLightUID;
};
/******************************************************************************/
RemoveLight::RemoveLight() : BaseEvent(), m_VarPointLight(null)      
{
   
}
RemoveLight::~RemoveLight()
{
   
}
/******************************************************************************/
void RemoveLight::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarLightUID")) m_VarPointLightUID = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void RemoveLight::AfterCreate()
{
   // Find the correct VarPointLight to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesPointLight)
      if(variablesPointLight[i].id() == m_VarPointLightUID)
         m_VarPointLight = &variablesPointLight[i];
         
   DEBUG_ASSERT(m_VarPointLight != null, "RemoveLight: Light var not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void RemoveLight::CallTriggeredAction()
{
   m_VarPointLight->SetDraw(false); 
}

// This method is called when the duration of the event has been reached
void RemoveLight::StopTriggeredAction()
{
   m_VarPointLight->SetDraw(true); // Start drawing a light in drawPrepare()
}
/******************************************************************************/
