/******************************************************************************/
class ShakeCamera : BaseEvent
{
public:
            ShakeCamera();
   virtual ~ShakeCamera();
   
   virtual void create(Object &obj); 
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   Vec2 m_Offset, m_Speed;
};
/******************************************************************************/
ShakeCamera::ShakeCamera() : BaseEvent(), m_Offset(0), m_Speed(0)                         
{
   
}
ShakeCamera::~ShakeCamera()
{
   
}
/******************************************************************************/
void ShakeCamera::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Offset")) m_Offset = p.asVec2();
   if(Param *p = obj.findParam("Speed"))  m_Speed  = p.asVec2();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void ShakeCamera::CallTriggeredAction()
{
   camera.StartCamShake(m_Offset, m_Speed); 
}

// This method is called when the duration of the event has been reached
void ShakeCamera::StopTriggeredAction()
{
   camera.StopCamShake(); 
}
/******************************************************************************/