// Based on the Cursor class from the EE RPG 2 sources
/******************************************************************************/
class Interact
{
public:
   
   void clear() { valid = highlight = false; obj.clear(); } // Clear all info
   void update(); 
   
   Reference<Game.Obj> obj;
   bool valid, highlight;
   
} Interact interaction;
/******************************************************************************/
void Interact::update()
{
   clear();
   
   if(Players.elms())
   {
      Player &player = Players[0];
      
      if(!valid)
      {   
         C OrientP *head=Players[0].skel.getSlot("head"); // obtain player "head" skeleton slot (this was created in Object Editor) 
         Vec dir = head.dir;
         Vec pos = head.pos + (dir * 0.5f);
         
         PhysHit hit;
         if(Physics.ray(pos, dir*10, &hit))
         {
            valid = true;
            obj = (Game.Obj*)hit.obj;
            
            // Set the mesh to be highlighted
            highlight = true;
            
            // Clicked on the object
            if(Ms.bp(0))
            {
                    if(ButtonObject  *temp = CAST(ButtonObject, &obj())) temp.Activate();
               else if(Item          *temp = CAST(        Item, &obj())) temp.PickedUp();
            
               Ms.eat(0); // Eat the mouse operation (this mouse click does not count for anything else in the project)
            }
         }
      }
   } 
}
/******************************************************************************/